<?php $__env->startSection('title', 'Notifikasi'); ?>

<?php $__env->startSection('content'); ?>
<div class="notifikasi-wrapper">
    <!-- Filter Tabs -->
    <div class="filter-tabs">
        <button class="tab-btn active" data-filter="all">All</button>
        <button class="tab-btn" data-filter="absensi">Absensi</button>
        <button class="tab-btn" data-filter="gaji">Gaji</button>
        <button class="tab-btn" data-filter="cuti">Cuti</button>
        <button class="tab-btn" data-filter="sistem">Sistem</button>
    </div>

    <!-- Notifications List -->
    <div class="notifications-list">
        <?php $__empty_1 = true; $__currentLoopData = $notifikasi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <?php
            $iconClass = 'fa-bell';
            $iconBg = '#6c757d';

            switch($n->type) {
                case 'cuti':
                    $iconClass = 'fa-calendar-alt';
                    $iconBg = '#3b82f6';
                    break;
                case 'absensi':
                    $iconClass = 'fa-clipboard-check';
                    $iconBg = '#06b6d4';
                    break;
                case 'gaji':
                    $iconClass = 'fa-money-bill-wave';
                    $iconBg = '#10b981';
                    break;
            }
        ?>

        <div class="notification-item <?php echo e(!$n->is_read ? 'unread' : ''); ?>" data-type="<?php echo e($n->type); ?>">
            <div class="notification-card" onclick="markAsRead(<?php echo e($n->id); ?>)">
                <div class="notification-icon" style="background: <?php echo e($iconBg); ?>;">
                    <i class="fas <?php echo e($iconClass); ?>"></i>
                </div>

                <div class="notification-content">
                    <div class="notification-header">
                        <h3 class="notification-title"><?php echo e($n->judul); ?></h3>
                        <span class="notification-time"><?php echo e($n->created_at->diffForHumans()); ?></span>
                    </div>
                    <p class="notification-message"><?php echo e($n->pesan); ?></p>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-inbox"></i>
            </div>
            <h3>Tidak ada notifikasi</h3>
            <p>Semua notifikasi akan muncul di sini</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if($notifikasi->hasPages()): ?>
    <div class="pagination-wrapper">
        <?php echo e($notifikasi->links()); ?>

    </div>
    <?php endif; ?>
</div>

<?php echo $__env->make('notifikasi.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('notifikasi.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('karyawan.layout.fullscreen', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/notifikasi/karyawan.blade.php ENDPATH**/ ?>